
#|___________________________________________________________________ 
 | 
 | ViSta - The Visual Statistics System
 | Copyright (c) 1991-2000 by Forrest W. Young
 | For further information contact the author 
 | forrest@unc.edu or http://forrest.psych.unc.edu
 |
 | This file determines MS-Windows 95, 98, NT, 2000 installation
 | for directories, window layout, fonts and startup privileges
 |___________________________________________________________________ 
 |#
;            (vista-installation-hyperlog)
;(showmainwindow)
(defun nil ())

(defun vista-installation-hyperlog ()
  (send vista-hyper-install-proto :new ))

(defproto vista-hyper-install-proto)

(defmeth vista-hyper-install-proto :isnew ()
  (call-next-method)
  (send self :make-hyperlog )
  )


(defmeth vista-hyper-install-proto :make-hyperlog ()
  (setf *vista-hyperlog* self)
  (send *vista-hyperlog* :initialize)
  (setf *pro-choices* (if *pro-version* 3 2))

  (hyper-dialog

  
   (defun installation-welcome ()
     (installation-type))

   (defun installation-type ()
     '(button-hyper-dialog 
       (list "SINGLE USER,  NO NETWORK" "  ALL OTHER SITUATIONS  ")
       :header (format nil "Please choose the appropriate installation method:")
       :button-text (list (format nil 
"Install ViSta on THIS MACHINE for~%use by ~a" (if *pro-version* (FORMAT NIL "one VISTA DEVELOPER.") "ONE person.")) (format nil "Install ViSta in ALL OTHER situations."))
       :text (format nil 
"The SINGLE USER,  NO NETWORK installation can also be used when~%ViSta is installed on a network server for one person using one client.~2%CLICK INFO, below, for information on the details of the single user,~%no network installation.")
       :title  "ViSta - The Visual Statistics System"
       :links  (list '(hyperlog-default-install)
                     '(progn
                       (setf *installation-type* "CUSTOM")
                       (custom-install)))
       :action (list '(continue)'(continue))
       :divider (format nil "____________________________________________________________")
       
       :help   '(send *vista-hyperlog* :get-installer-type-help) 
       :info '(send *vista-hyperlog* :summary  0 t)
       :layout (list (list 'help 'info))
       :footer (format nil "Click HELP for help using this dialog box.~%Click INFO for details on the default installation.")
       :supervisor *vista-hyperlog*
       ))

(defun ok-to-install? ()
    '(button-hyper-dialog 
      (list "OK - INSTALL" "NO - REVISE " )
      :text (format nil 
"You have choosen DEFAULT INSTALL, which is most appropriate~%when ViSta will be used by just one user. The default includes~%an Excel-to-ViSta connection so that you can visualize your Excel data.~a~2%CLICK INFO, below, for information on the details of the default installation." 
(if *pro-version* (format nil "~%The default installation also gives you DEVELOPER RIGHTS.") " "))
      :header "THE DEFAULT INSTALLATION HAS BEEN PREPARED! SHALL I PROCEED?"
      :button-text (list (format nil "Click OK - INSTALL to use the DEFAULT installation.")
                          (format nil "Click NO - REVISE to start over."))
      :title  "ViSta - The Visual Statistics System"
      :links  (list '(progn
                       (setf *installation-type* "DEFAULT")
                       (send *vista-hyperlog* :set-default-install *pro-version*)
                       (when *pro-version* (set-devel-mode t))
                       (send *vista-hyperlog* :save-installation)
                       (hyperlog-default-install))
                    '(installation-type))
      :action (list '(continue) '(continue))
      :divider (format nil "_______________________________________________________________")
       
      :help   '(send *vista-hyperlog* :get-welcome-help) 
      :info   '(send *vista-hyperlog* :summary  0 t)
      :first   t
      :exit    t
      :layout (list (list 'help 'info 'first 'exit))
      :footer (format nil "Click HELP for help using this dialog.         Click FIRST to start over.~%Click INFO for installation status.                Click EXIT to exit the installation.")
      :supervisor *vista-hyperlog*
      ))
                
   (defun custom-install () 
     (setf *installation-type* "CUSTOM")
     '(button-hyper-dialog 
       (list "NEXT")
       :button-text (list (format nil 
"When you click NEXT you will see the first in a~%series of dialog boxes asking for installation information.~2%In these dialogs there will be buttons on the left~%and buttons at the bottom.~2%Use the left-hand buttons to choose installation details~%Use the bottom buttons to clarify choices and to~%go back to previous dialogs."))
       :divider (format nil 
"____________________________________________________________")
       :footer (format nil "HELP with the dialog - INFO about installation.~%FIRST to start over - BACK to previous step")
       :title  "ViSta - The Visual Statistics System"
       :header "Welcome to ViSta's Custom Installation"
       :links   (list '(computing-environment))
       :action (list '(nil))
       :help '(send *vista-hyperlog* :get-custom-install-help)
       :info '(send *vista-hyperlog* :summary  0 t)
       :first   t
       :back   '(installation-type)
       :layout (list (list 'help 'info 'first 'back ))
       :supervisor *vista-hyperlog*
       ))

   (defun computing-environment ()
"Sets *computing-environment* to COMPUTER or NETWORK. If NETWORK, also sets *number-of-users*=Many, *user-type*=NetUser, *pro-version*=nil, *update-pref-files* "nil" and *installer-type* to Admin"
     '(button-hyper-dialog 
       (list "THIS COMPUTER" "THE NETWORK  ")
       :button-text (list (format nil "Choose THIS COMPUTER if ViSta will~%only be used on this Computer") (format nil "Choose THE NETWORK if ViSta will~%be used on a network of computers") )
       :title  "ViSta - The Visual Statistics System" 
       :header "For Which Computing Environment is ViSta Being Installed?"
       :first  t
       :back   '(custom-install)
       :links   (list '(number-of-users) '(ini-location 4))
       :action (list '(progn
                       (setf *computing-environment* "COMPUTER")
                       (setf *installer-type* "User")
                       (setf *number-of-users* "ONE")
                       (setf *user-type* "User")
                       (set-user-privileges "User"))
                     '(progn
                       (setf *computing-environment* "NETWORK")
                       (setf *installer-type* "Admin")
                       (setf *number-of-users* "MANY")
                       (setf *user-type* "NetUser")
                       (set-user-privileges "NetUser")))
       :help   '(send *vista-hyperlog* :get-installation-type-help)
       :info   '(send *vista-hyperlog* :summary  0 t)
       :layout (list (list 'help 'info 'first 'back ))
       :divider (format nil "____________________________________________________________")
       :footer (format nil "Click HELP for help using this dialog.         Click FIRST to start over.~%Click INFO for installation status.                Click BACK to go to the previous step.")
       :supervisor *vista-hyperlog*
       ))
   
   (defun number-of-users ()
     '(button-hyper-dialog 
       (list "ONE" "SEVERAL")
       :button-text (list "Click ONE when there is just  one user."
                          "Click SEVERAL if there will be several.")
       :title  "ViSta - The Visual Statistics System" 
       :header "How Many Users Will Be Using ViSta on This Computer?"
       :links  (list '(progn
                       (setf *number-of-users* "ONE")
                       (setf *user-type* "User")
                       (set-user-privileges "User")
                       (ini-location 2))
                     '(progn
                       (setf *number-of-users* "MANY")
                       (setf *user-type* "NetUser")
                       (set-user-privileges "NetUser")
                       (ini-location 3)))
       :action (list '(continue) '(continue))
       :help   '(send *vista-hyperlog* :get-user-type-help)
       :info   '(send *vista-hyperlog* :summary  0 t)
       :first  t
       :back   '(computing-environment)
       :layout (list (list 'help 'info 'first 'back ))
       :divider (format nil "____________________________________________________________")
       :footer (format nil "Click HELP for help using this dialog.         Click FIRST to start over.~%Click INFO for installation status.                Click BACK to go to the previous step.")
       :supervisor *vista-hyperlog*
       ))

 
(defun ini-location (n)
  (setf *num-choices* n)
  '(button-hyper-dialog 
    (select (list "VISTA" "SYSTEM" "USER'S" "SERVER") (iseq *num-choices*))
    :button-text (select (list "In ViSta's Home Directory"
                               "In This Computer's System Directory"
                               "In The Users' Home Directories"
                               "In The Server's System Directory")
                         (iseq *num-choices*))
    :title  "ViSta - The Visual Statistics System" 
    :header "Where Do You Want ViSta's WXLS32.INI File to be located?"
    :links  (select (list '(progn
                            (setf *ini-at-home* t)
                            (setf *ini-loc-type* "ViSta")
                            (setf *ini-file* (strcat *default-path* "wxls32.ini"))
                            (save-work-directory))
                          '(progn
                            (setf *ini-at-home* nil)
                            (setf *ini-loc-type* "System")
                            (setf *ini-file* (strcat *system-path* "wxls32.ini"))
                            (save-work-directory))
                          '(progn
                            (setf *ini-at-home* t)
                            (setf *ini-loc-type* "UserHome")
                            (setf *ini-file* (strcat *default-path* "wxls32.ini"))
                            (send *vista-hyperlog* :get-ini-loc-help)
                            (save-work-directory))
                          '(progn
                            (setf *ini-at-home* t)
                            (setf *ini-loc-type* "Server")
                            (setf *ini-file* (strcat *default-path* "wxls32.ini"))
                            (send *vista-hyperlog* :get-ini-loc-help)
                            (save-work-directory)))
                    (iseq *num-choices*))
       :action (select (list '(continue) '(continue) '(continue) '(continue)) 
                       (iseq *num-choices*))
       :help   '(send *vista-hyperlog* :get-ini-loc-help)
    :info   '(send *vista-hyperlog* :summary  0 t)
    :first  t
    :back   '(case *num-choices* (2 (number-of-users)) 
               (3 (number-of-users)) (4 (computing-environment)))
    :layout (list (list 'help 'info 'first 'back ))
    :divider (format nil "____________________________________________________________")
    :footer (format nil "Click HELP for help using this dialog.         Click FIRST to start over.~%Click INFO for installation status.                Click BACK to go to the previous step.")
       :supervisor *vista-hyperlog*
       ))


  (defun save-work-directory ()
    '(edit-text-hyper-dialog *user-path*
      :title  "ViSta - The Visual Statistics System" 
      :header "The Default Directory For the User to Save Work In Is" 
      :first  t
      :back   '(ini-location  *num-choices*)
      :next   (list '(ready-to-setup))
      :next-in-body t
      :action (list '(progn
                      (setf hl (send self :hyper-dialog))
                      (setf editext (when hl (send hl :edited-text)))
                      (set-new-user-path editext)))
      :help   '(send *vista-hyperlog* :get-save-work-help)
      :info   '(send *vista-hyperlog* :summary  0 t)
      :layout (list (list 'help 'info 'first 'back ))
      :divider (format nil "____________________________________________________________")
      :footer (format nil "HELP with the dialog - INFO about installation.~%FIRST to start over - BACK to previous step")
      :supervisor *vista-hyperlog*
      ))


   (defun ready-to-setup ()
     '(button-hyper-dialog 
       (list "REVISE" "INSTALL")
       :button-text (list "Click REVISE to revise the installation"
                          "Click INSTALL to install and Run ViSta")
       :title  "ViSta - The Visual Statistics System" 
       :header "ViSta Is Ready to Install." 
       :action (list '(continue) '(continue))
       :first  t
       :back   '(save-work-directory)
       :links  (list '(installation-type) 
                     '(customized-install))
       :help   '(send *vista-hyperlog* :ready-to-do-install)
       :info   '(send *vista-hyperlog* :summary  0 t)
       :layout (list (list 'help 'info 'first 'back ))
       :divider (format nil "____________________________________________________________")
       :footer (format nil "Click HELP for help using this dialog.         Click FIRST to start over.~%Click INFO for installation status.                Click BACK to go to the previous step.")
       :supervisor *vista-hyperlog*
       ))



   ))

(defmeth vista-hyper-install-proto :start-hyperlog ()
      (installation-type) 
      (top-level))

(defmeth vista-hyper-install-proto :initialize ()
  (send self :set-default-install))

(defun customized-install ()
  (cond
    ((send *vista-hyperlog* :summary  0 nil)
     (send *vista-hyperlog* :save-installation)
     (vista-with-logo))
    (t (install-vista))))

(defun hyperlog-default-install ()
  (setf *installation-type* "DEFAULT")
  (send *vista-hyperlog* :set-default-install *pro-version*)
  (when *pro-version* (set-devel-mode t))
  (send *vista-hyperlog* :save-installation)
  (vista-with-logo)
  )

(defun vista-with-logo ()
  (when *show-install-logo* 
        (apply 'send *logo* :location *logo-location*)
        (send *logo* :redraw))
  (start-vista)
  (save-current-workspace "XLisp.WKS" nil nil t)
  )

(defmeth vista-hyper-install-proto :set-default-install (&optional (developer nil used?))
  (if used? (set-default-install developer)
      (set-default-install)))

(defun set-default-install (&optional (developer nil used?))
  (setf *pro-version* developer)
  (setf *ini-loc-choice-num* 0)
  (set-ini-file 0)
  (setf *initial-install* t)
  (setf *installation-type* (if developer "DEVELOPER" "DEFAULT"))
  (setf *computing-environment* "COMPUTER")
  (setf *number-of-users* "ONE")
  (setf *installer-type* "User")
  (setf *user-type* "User")
  (setf *update-pref-files* t)
  (set-user-privileges (if developer "Developer" "User"))
  (if used?
      (set-vista-pro-version developer)
      (set-vista-pro-version))
  (set-ini-file "ViSta")
  (set-new-user-path "C:\\MyViSta\\")
  (set-vista-data-library-path (strcat *default-path* "data"    *separator*))
  (set-menu-item-defaults)
  (set-ini-file 0)
  (setf *change-excess* t)
  (setf *local-excel?* t)
  (setf *no-local-excel?* nil)
  )

(defmeth vista-hyper-install-proto :set-user-privileges (user-type)
  (set-user-privileges user-type))

(defmeth vista-hyper-install-proto :set-vista-pro-version ()
  (set-vista-pro-version))


(defun set-menu-item-defaults ()
  (cond
    (*pro-version*
     (setf *show-devel-menu* t)
     (setf *update-pref-files* t)
     (setf *change-profiles* t)
     (setf *change-toolbar* t)
     (setf *change-workmap* t)
     (setf *change-excess* t)
     (setf *configure* t)
     )
    ((equal "User" *user-type*)
     (setf *show-devel-menu* nil)
     (setf *update-pref-files* t)
     (setf *change-profiles* t)
     (setf *change-toolbar* t)
     (setf *change-workmap* t)
     (setf *change-excess* t)
     (setf *configure* t)
     )
    (t
     (setf *show-devel-menu* nil)
     (setf *update-pref-files* nil)
     (setf *change-profiles* t)
     (setf *change-toolbar* nil)
     (setf *change-workmap* t)
     (setf *change-excess* nil)
     (setf *configure* nil)
     ))
  t)

(defun set-new-user-path (up)
  (setf *user-dir-name* up)
  (setf *user-path* *user-dir-name*)
  *user-path*)

(defun set-vista-data-library-path (lp)
  (setf *data-path* lp)
  (setf *data-dir-name* *data-path*)
  (setf *examples-data-dir-name* *data-path*)
  (setf *current-data-dir-name*  *data-path*)
  *data-path*)

(defun set-ini-file (n)
  (cond 
    ((integerp n)
     (setf *ini-at-home* (if (= n 1) nil t))
     (setf *ini-loc-type* (select (list "ViSta" "System" "UserHome" "Server") n)))
    ((stringp n)
     (setf *ini-at-home* (if (equal n "System") nil t))
     (setf *ini-loc-type* n)))
  (cond
    ((equal *ini-loc-type* "ViSta")
     (setf *ini-file* (strcat *default-path* "wxls32.ini")))
    ((equal *ini-loc-type* "System")
     (setf *ini-file* (strcat *system-path* "wxls32.ini")))
    (t
     (setf *ini-file* (strcat *default-path* "wxls32.ini"))
     (send *vista-hyperlog* :get-ini-loc-help)))
  )

(defmeth vista-hyper-install-proto :save-installation ()
   (let ((upf *update-pref-files*))
     (setf *update-pref-files* t)
     (setf *initial-install* nil)
     (write-ini-paths)
     (write-prefload-file)
     (write-initial-file)
     (setf *update-pref-files* upf)
     ))

(defun vista-install-info ()
  (send *vista-hyperlog* :summary 0 t))

(defmeth vista-hyper-install-proto :summary (in-step &optional one-button)
  (installation-summary one-button))

(setf *installation-type* nil)
           
(setf *computing-environment* nil)

(defmeth vista-hyper-install-proto :get-welcome-help ()
  (message-dialog (format nil 
"This welcome dialog introduces you to~%ViSta's Installation Wizard which will~%guide you through the installation process.~%Just click CONTINUE to proceed.")))

(defmeth vista-hyper-install-proto :get-custom-install-help ()
  (message-dialog (format nil 
"In the previous dialog you chose~2%\"CUSTOM INSTALL\"~2%This is appropriate if you are a user who will be sharing~%ViSta with others on this machine, or if you are a system or~%network administrator installing ViSta on a server or on a~%machine where it will be used by more than one user.~2%If \"CUSTOM INSTALL\" was the wrong choice, click on BACK.~%If \"CUSTOM INSTALL\" was the right choice, click on NEXT.")))


(defmeth vista-hyper-install-proto :get-installer-type-help ()
  (message-dialog (format nil 
"Choose \"DEFAULT INSTALL\" if you will be the only person~%using ViSta on this machine.~2%Choose \"CUSTOM INSTALL\" if you are a user who will be sharing~%ViSta with others on this machine, or if you are a system or~%network administrator installing ViSta on a server or on a~%machine where it will be used by more than one user")))


(defmeth vista-hyper-install-proto :get-installation-type-help ()
  (one-button-dialog (format nil 
"This dialog determines which installation~%dialogs will be shown.~2%Choose THIS COMPUTER if ViSta is being~%installed to run just on this computer.~2%Choose THE NETWORK if ViSta is being installed~%to run on several computers which are connected~%together by a network. This choice should only~%be used by network or system administrators~%or by advanced users.")))


(defmeth vista-hyper-install-proto :get-user-type-help ()
  (message-dialog (format nil 
"This dialog controls access to certain ViSta features~%which can permanently modify the user's environment.~2%Choice 1: JUST ONE USER of a locally Installed ViSta~%has full access to all features. Modifications~%to ViSta's environment are saved between sessions.~2%Choice 2: SEVERAL USERS of either a locally or a~%remotely installed ViSta have limited access to~%features which modify ViSta's user environment.~%Additionally, these users cannot save changes between~%sessions. They can only write to the User Directory,~%which is specified later in the installation.~2%"))) 
       

(defmeth vista-hyper-install-proto :get-ini-loc-help ()
  (message-dialog (format nil 
"This message is addressed to the Network Administrator~2%The WXLS32.INI file determines ViSta's startup environment.~%The Installation give you 4 ways to locate the .INI file,~%however, the last two choices cannot be carried out without~%you taking additional actions.~2%You can choose to place the .INI file in the ViSta directory,~%(the directory containing the ViSta.exe file), on in this computer's~%system directory.~2%However, to locate the .INI file in the network server's system~%directory, or in the users' home directories on the network you~%must to take additional steps.~2%To install on the network server's system directory you must be~%using the network server and choose \"This Computer's System~%Directory\". To install in the user's directories you must choose~%\"This Computer's ViSta Directory\" and then move the .INI file~%to the appropriate locations.~2%Since the .INI file must be writable by each user, the~%preferred location depends on details of your network's~%access privileges~2%"))) 


(defmeth vista-hyper-install-proto :get-config-help ()
  (message-dialog (format nil 
"You can revise or accept this configuration,~%including the UPPER CASE values~%in the text at the top of the dialog.")))

(defmeth vista-hyper-install-proto :ready-to-do-install ()
  (message-dialog (format nil
"Click INSTALL if you are ready to install ViSta~%
Click REVISE is you wish to change the installation")))

(defmeth vista-hyper-install-proto :get-save-work-help ()
   (message-dialog (format nil 
"This dialog determines the initial directory location~%for dialog boxes the user uses to save work results.~%The user must have write privileges for this location.")))

(defmeth vista-hyper-install-proto :get-data-library-help ()
   (message-dialog (format nil 
"This dialog determines the location of the data~%library and the initial directory location for~%dialog boxes that point to the data library.~2%The user does not need to have write privileges~%for this location.")))

(defun install-excel?-help ()
  (message-dialog (format nil "You can give Excel Users quick and easy~%access to ViSta's Visualizations.~2%Click YES if you wish to do so.~2%Click NO if you do not wish to do so.")))
